// priority: 11
global.冰豆腐砖 = {
    物品ID: "kubejs:ice_tofu",
    冷却时间: 1.5,
    伤害倍率: 0.8,
    伤害半径: 2.5,
    忽略实体: [
        "minecraft:player",
        "touhoulittlemaid:maid"
    ]
};

ItemEvents.rightClicked(global.冰豆腐砖.物品ID, e => {
    if (e.player.level.isClientSide()) {
        return;
    }

    let p = e.player;
    let 物品冷却管理器 = p.getCooldowns();

    if (物品冷却管理器.isOnCooldown(e.item.item)) {
        return;
    }

    let 世界 = e.level;
    物品冷却管理器.addCooldown(e.item.item, global.冰豆腐砖.冷却时间 * 20);
    let 基础伤害 = p.getAttributeValue("minecraft:generic.attack_damage");
    let 最终伤害 = 基础伤害 * global.冰豆腐砖.伤害倍率;
    let 搜索区域 = p.getBoundingBox().inflate(global.冰豆腐砖.伤害半径);
    let 附近所有实体 = 世界.getEntitiesWithin(搜索区域);
    let 伤害类型注册表 = 世界.registryAccess().registry($注册表类.DAMAGE_TYPE).get();
    let 资源键 = $资源键.create(伤害类型注册表.key(), new $资源位置("minecraft:freeze"));
    let 伤害类型持有者 = 伤害类型注册表.getHolder(资源键);
    
    let 伤害源 = new ($伤害源)(伤害类型持有者.get(), p, p);
    
    let 受伤目标计数 = 0;

    for (let 目标实体 of 附近所有实体) {
        if (!目标实体.isLiving()) {
            continue;
        }

        let 实体ID = `${目标实体.getType()}`;
        if (global.冰豆腐砖.忽略实体.includes(实体ID) || 目标实体.is(p)) {
            continue;
        }

        目标实体.attack(伤害源, 最终伤害);
        受伤目标计数 = 受伤目标计数 + 1;
    }

    if (受伤目标计数 > 0) {
        世界.playSound(null, p.x, p.y, p.z, "kubejs:xzg", "master", 1.0, 1.0);
    }
    e.success();
});